﻿using System;
using System.Web;
using System.Web.UI.WebControls;
using VIRP_WEB.BaseCode;

namespace VIRP_WEB.Custom.EFR
{
    public partial class LabOrders : EfrBasePage
    {
        protected override void Page_Load(object sender, EventArgs e)
        {
            //ReplacePageTitle();

            if (!IsPostBack)
            {
                int statusId;
                if (int.TryParse(Request.QueryString["statusId"], out statusId))
                {
                    //check if it's in-process or completed questionnaire(now in new status)
                    if (statusId == 6)
                    {
                        GridViewEFRLabOrders.Columns[0].Visible = true;
                        GridViewEFRLabOrders.Columns[1].Visible = false;
                        GridViewEFRLabOrders.Columns[2].Visible = true;
                        GridViewEFRLabOrders.Columns[3].Visible = true;
                        GridViewEFRLabOrders.Columns[4].Visible = true;
                        GridViewEFRLabOrders.Columns[5].Visible = false;
                        GridViewEFRLabOrders.Columns[6].Visible = false;
                        GridViewEFRLabOrders.Columns[7].Visible = false;
                        GridViewEFRLabOrders.Columns[8].Visible = true;
                        GridViewEFRLabOrders.Columns[9].Visible = true;
                        GridViewEFRLabOrders.Columns[10].Visible = false;

                        ReplacePageTitle("My Tasks > Lab Orders > New");
                    }
                    //survey type is not shown here

                    if (statusId == 1 || statusId == 3)
                    {
                        SetDropDownFilterBy();

                        GridViewEFRLabOrders.Columns[0].Visible = true;
                        GridViewEFRLabOrders.Columns[1].Visible = true;
                        GridViewEFRLabOrders.Columns[2].Visible = true;
                        GridViewEFRLabOrders.Columns[3].Visible = true;
                        GridViewEFRLabOrders.Columns[4].Visible = true;
                        GridViewEFRLabOrders.Columns[5].Visible = true;
                        GridViewEFRLabOrders.Columns[6].Visible = false;
                        GridViewEFRLabOrders.Columns[7].Visible = false;
                        GridViewEFRLabOrders.Columns[8].Visible = true;
                        GridViewEFRLabOrders.Columns[9].Visible = true;
                        GridViewEFRLabOrders.Columns[10].Visible = true;

                        if (statusId == 1)
                            ReplacePageTitle("My Tasks > Lab Orders > In Process");
                        else
                            ReplacePageTitle("My Tasks > Lab Orders > Voided");
                    }

                    if (statusId == 9)
                    {
                        SetDropDownFilterBy();

                        GridViewEFRLabOrders.Columns[0].Visible = true;
                        GridViewEFRLabOrders.Columns[1].Visible = true;
                        GridViewEFRLabOrders.Columns[2].Visible = true;
                        GridViewEFRLabOrders.Columns[3].Visible = true;
                        GridViewEFRLabOrders.Columns[4].Visible = true;
                        GridViewEFRLabOrders.Columns[5].Visible = true;
                        GridViewEFRLabOrders.Columns[6].Visible = false;
                        GridViewEFRLabOrders.Columns[7].Visible = true;
                        GridViewEFRLabOrders.Columns[8].Visible = true;
                        GridViewEFRLabOrders.Columns[9].Visible = true;
                        GridViewEFRLabOrders.Columns[10].Visible = true;

                        ReplacePageTitle("My Tasks > Lab Orders > Closed");
                    }
                    if (statusId == 2)
                    {
                        GridViewEFRLabOrders.Columns[0].Visible = true;
                        GridViewEFRLabOrders.Columns[1].Visible = true;
                        GridViewEFRLabOrders.Columns[2].Visible = true;
                        GridViewEFRLabOrders.Columns[3].Visible = true;
                        GridViewEFRLabOrders.Columns[4].Visible = true;
                        GridViewEFRLabOrders.Columns[5].Visible = true;
                        GridViewEFRLabOrders.Columns[6].Visible = true;
                        GridViewEFRLabOrders.Columns[7].Visible = false;
                        GridViewEFRLabOrders.Columns[8].Visible = true;
                        GridViewEFRLabOrders.Columns[9].Visible = true;
                        GridViewEFRLabOrders.Columns[10].Visible = true;

                        ReplacePageTitle("My Tasks > Lab Orders > Completed");
                    }
                    if (statusId == 11)
                    {
                        SetDropDownFilterBy();

                        GridViewEFRLabOrders.Columns[0].Visible = true;
                        GridViewEFRLabOrders.Columns[1].Visible = true;
                        GridViewEFRLabOrders.Columns[2].Visible = true;
                        GridViewEFRLabOrders.Columns[3].Visible = true;
                        GridViewEFRLabOrders.Columns[4].Visible = true;
                        GridViewEFRLabOrders.Columns[5].Visible = true;
                        GridViewEFRLabOrders.Columns[6].Visible = true;
                        GridViewEFRLabOrders.Columns[7].Visible = false;
                        GridViewEFRLabOrders.Columns[8].Visible = true;
                        GridViewEFRLabOrders.Columns[9].Visible = true;
                        GridViewEFRLabOrders.Columns[10].Visible = true;

                        ReplacePageTitle("My Tasks > Lab Orders > Awaiting Results");
                    }
                }
                // Set the default sort to the caseId
                GridViewEFRLabOrders.Sort("CaseId", SortDirection.Descending);

                HiddenFieldClearFlag.Value = "0";
            }

            // Added for 508 compliance with GridView column headers and footer
            Page.ClientScript.RegisterStartupScript(GetType(), "UpdateGridView", "UpdateGridView('" + GridViewEFRLabOrders.ClientID + "');", true);
        }

        public void SetDropDownFilterBy()
        {
            DropDownFilterBy.Visible = true;
            LabelSearchCriteria.Text = "Filter by:";
            LabelSearchCriteria.AssociatedControlID = DropDownFilterBy.ID;
        }

        public void LabOrders_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            if (e.CommandName == "Details")
            {
                int index = Convert.ToInt32(e.CommandArgument);
                GridViewEFRLabOrders.SelectedIndex = index;
                int id = Convert.ToInt32(GridViewEFRLabOrders.SelectedValue);
                //calling the right page for different order lab order types
                Label orderType = GridViewEFRLabOrders.SelectedRow.FindControl("LabelOrderType") as Label;
                if (orderType != null && !string.IsNullOrEmpty(orderType.Text))
                {
                    if (orderType.Text.Equals("Biological Monitoring", StringComparison.OrdinalIgnoreCase))
                        Response.Redirect(string.Format("LabOrder.aspx?activityId={0}", id));
                    else
                        Response.Redirect(string.Format("FragLabOrder.aspx?activityId={0}", id));
                }
            }
        }

        protected void ButtonClear_Click(object sender, EventArgs e)
        {
            TextBoxSearchCriteria.Text = String.Empty;
            HiddenFieldClearFlag.Value = "1";
        }

        protected void ButtonOK_Click(object sender, EventArgs e)
        {
            GridViewEFRLabOrders.PageIndex = 0;

            if (DropDownFilterBy.Visible && string.IsNullOrEmpty(DropDownFilterBy.SelectedValue))
            {
                TextBoxSearchCriteria.Text = "";
                HiddenFieldClearFlag.Value = "0";
            }
        }

        protected override void Ds_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                //e.InputParameters.Clear();

                //string txtSearch = TextBoxSearchCriteria.Text;
                //string listFacility = DropDownListFacility.SelectedValue;

                if (e.InputParameters["CURRENT_USER"] != null)
                    e.InputParameters["CURRENT_USER"] = HttpContext.Current.User.Identity.Name;
                else
                    e.InputParameters.Add("CURRENT_USER", HttpContext.Current.User.Identity.Name);

                if (e.InputParameters["CURRENT_REGISTRY_ID"] != null)
                    e.InputParameters["CURRENT_REGISTRY_ID"] = UserSession.CurrentRegistryId;
                else
                    e.InputParameters.Add("CURRENT_REGISTRY_ID", UserSession.CurrentRegistryId);

                //e.InputParameters.Add("lastName", txtSearch);
                //e.InputParameters.Add("facilityId", listFacility);
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }
    }
}